/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.mx.containers.VBox;
import intrinsic.mx.controls.Label;
import intrinsic.mx.core.Container;
import intrinsic.mx.core.EdgeMetrics;
import intrinsic.mx.core.ScrollPolicy;
import intrinsic.mx.core.UIComponent;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Group extends Composite {
	String text = "";
	VBox boxComponent;
	Label labelComponent;
	
	static final int INDENT = 5;

public Group (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	style |= SWT.NO_FOCUS;
	/*
	* Even though it is legal to create this widget
	* with scroll bars, they serve no useful purpose
	* because they do not automatically scroll the
	* widget's client area.  The fix is to clear
	* the SWT style.
	*/
	return style & ~(SWT.H_SCROLL | SWT.V_SCROLL);
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

public Point computeSize(int wHint, int hHint, boolean changed) {
	Point size = super.computeSize(wHint, hHint, changed);
	if (labelComponent.visible) {
		size.x = Math.max(size.x, (int)labelComponent.width + INDENT * 2);
	}
	return size;
}

public Rectangle computeTrim(int x, int y, int width, int height) {
	Rectangle trim = super.computeTrim(x, y, width, height);
	trim.y -= labelComponent.measuredHeight;
	trim.height += labelComponent.measuredHeight;
	trim.width = Math.max(trim.width, (int)labelComponent.width + INDENT * 2);
	return trim;
}

void createHandle () {
	VBox boxWidget = new VBox();
	boxWidget.horizontalScrollPolicy = boxWidget.verticalScrollPolicy = ScrollPolicy.OFF;
	boxWidget.setStyle("verticalGap", 0);
	intrinsic.mx.controls.Label labelWidget = new intrinsic.mx.controls.Label();
	labelWidget.setStyle("paddingLeft", INDENT);
	labelWidget.setStyle("fontWeight", "bold");
	labelWidget.visible = false;
	labelWidget.includeInLayout = false;
	intrinsic.mx.containers.Canvas widget = new intrinsic.mx.containers.Canvas();
	widget.horizontalScrollPolicy = widget.verticalScrollPolicy = ScrollPolicy.OFF;
	widget.percentWidth = widget.percentHeight = 100;
	widget.setStyle("borderStyle", "solid");
	boxWidget.addChild(labelWidget);
	boxWidget.addChild(widget);
	boxComponent = boxWidget;
	labelComponent = labelWidget;
	object = widget;
}

public Rectangle getClientArea () {
	checkWidget ();
	double width = boxComponent.width, height = boxComponent.height;
	EdgeMetrics view = ((Container)object).viewMetrics;
	width -= (view.left + view.right);
	height -= (view.top + view.bottom);
	if (labelComponent.visible) {
		height -= labelComponent.measuredHeight;
	}
	return new Rectangle(0, 0, (int)width, (int)height);
}

String getNameText() {
	return getText ();
}

public String getText () {
	checkWidget ();
	return text;
}

void releaseWidget () {
	super.releaseWidget ();
	text = null;
}

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	text = string;
	labelComponent.text = string;
	boolean visible = text.length() > 0;
	labelComponent.visible = visible;
	labelComponent.includeInLayout = visible;
}

UIComponent topComponent() {
	return boxComponent;
}
}
